/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.beachparty.mixin;

import dev.architectury.networking.NetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import satisfyu.beachparty.block.RadioBlock;
import satisfyu.beachparty.networking.BeachpartyMessages;
import satisfyu.beachparty.registry.ObjectRegistry;
import satisfyu.beachparty.util.BeachpartyUtil;

@Mixin(value={MouseHandler.class})
public class MouseMixin {
    @Inject(method={"onScroll"}, at={@At(value="HEAD")}, cancellable=true)
    private void MouseScrollOnRadio(long window, double horizontal, double vertical, CallbackInfo ci) {
        if (window == Minecraft.m_91087_().m_91268_().m_85439_()) {
            Minecraft client = Minecraft.m_91087_();
            HitResult hitResult = client.f_91077_;
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                if (blockHitResult.m_6662_() != HitResult.Type.BLOCK) {
                    return;
                }
                BlockPos blockPos = blockHitResult.m_82425_();
                if (client.f_91073_ == null) {
                    return;
                }
                BlockState blockState = client.f_91073_.m_8055_(blockPos);
                if (blockState.m_60734_() != ObjectRegistry.RADIO.get() || !((Boolean)blockState.m_61143_((Property)RadioBlock.ON)).booleanValue()) {
                    return;
                }
                int scrollValue = (int)this.calculateScrollValue(vertical, client.f_91066_);
                this.handleScrollEvent(blockPos, scrollValue);
                ci.cancel();
            }
        }
    }

    private double calculateScrollValue(double vertical, Options options) {
        return (Boolean)options.m_231821_().m_231551_() != false ? Math.signum(vertical) : vertical * (Double)options.m_232122_().m_231551_();
    }

    private void handleScrollEvent(BlockPos blockPos, int scrollValue) {
        if (scrollValue == 0) {
            return;
        }
        FriendlyByteBuf buffer = BeachpartyUtil.createPacketBuf();
        buffer.m_130064_(blockPos);
        buffer.writeInt(scrollValue);
        NetworkManager.sendToServer((ResourceLocation)BeachpartyMessages.MOUSE_SCROLL_C2S, (FriendlyByteBuf)buffer);
    }
}

